IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[RC_DEB_HISTORICO_CPL_CHQ_LANC_CPL]') 
					AND type in (N'U')) 
BEGIN
CREATE TABLE [dbo].[RC_DEB_HISTORICO_CPL_CHQ_LANC_CPL](
	[CD_CTR] [int] NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_CHQ] [int] NOT NULL,
 CONSTRAINT [PK_RC_DEB_HISTORICO_CPL_CHQ_LANC_CPL] PRIMARY KEY CLUSTERED 
(
	[CD_CTR] ASC,
	[CD_EMP] ASC,
	[CD_CHQ] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[RC_DEB_HISTORICO_CPL_CHQ_LANC_CPL] ADD  CONSTRAINT [DF_RC_DEB_HISTORICO_CPL_CHQ_LANC_CPL_CD_CTR]  DEFAULT ((0)) FOR [CD_CTR]

ALTER TABLE [dbo].[RC_DEB_HISTORICO_CPL_CHQ_LANC_CPL] ADD  CONSTRAINT [DF_RC_DEB_HISTORICO_CPL_CHQ_LANC_CPL_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[RC_DEB_HISTORICO_CPL_CHQ_LANC_CPL] ADD  CONSTRAINT [DF_RC_DEB_HISTORICO_CPL_CHQ_LANC_CPL_CD_CHQ]  DEFAULT ((0)) FOR [CD_CHQ]

ALTER TABLE [dbo].[RC_DEB_HISTORICO_CPL_CHQ_LANC_CPL]  WITH CHECK ADD  CONSTRAINT [FK_RC_DEB_HISTORICO_CPL_CHQ_LANC_CPL_CHQ_LANC_CPL] FOREIGN KEY([CD_EMP], [CD_CHQ])
REFERENCES [dbo].[CHQ_LANC_CPL] ([CD_EMP], [CD_CHQ])

ALTER TABLE [dbo].[RC_DEB_HISTORICO_CPL_CHQ_LANC_CPL] CHECK CONSTRAINT [FK_RC_DEB_HISTORICO_CPL_CHQ_LANC_CPL_CHQ_LANC_CPL]

ALTER TABLE [dbo].[RC_DEB_HISTORICO_CPL_CHQ_LANC_CPL]  WITH CHECK ADD  CONSTRAINT [FK_RC_DEB_HISTORICO_CPL_CHQ_LANC_CPL_RC_DEB_HISTORICO] FOREIGN KEY([CD_CTR])
REFERENCES [dbo].[RC_DEB_HISTORICO] ([CD_CTR])

ALTER TABLE [dbo].[RC_DEB_HISTORICO_CPL_CHQ_LANC_CPL] CHECK CONSTRAINT [FK_RC_DEB_HISTORICO_CPL_CHQ_LANC_CPL_RC_DEB_HISTORICO]
end

